class AgedHealthVial extends MiniHealthPack;
	var Shader Green[4];
	var Shader Red[4];
	var int Age;
	var bool bPoison;
	var class<DamageType> DamageType;

	var bool bPoisonRules;
	var int startHeal;
	var int healStep;
	var int ageFreq;
	var float poisonChance;

function PreBeginPlay() {
	local Mutator M;
	super.PreBeginPlay();
	for ( M=Level.Game.BaseMutator; M!=None; M=M.NextMutator) {
		if (MutAgedToPerfection(M) != None) {
			bPoisonRules = MutAgedToPerfection(M).bDoneGoneBad;
			startHeal = MutAgedToPerfection(M).startHealth;
			healStep = MutAgedToPerfection(M).healthStep;
			ageFreq = MutAgedToPerfection(M).ageFreq;
			poisonChance = MutAgedToPerfection(M).badChance;
			break;
		}
	}
}

function SetRespawn() {
	if( Level.Game.ShouldRespawn(self) )
		StartSleeping();
	else
		Destroy();
}

auto state Pickup {

	function Timer() {
		if ( bDropped )
			GotoState('FadeOut');
		else {
			if (level.game.bWaitingToStartMatch)
				return;

			if(bPoison) {
				Skins[1]=Green[Age];
				HealingAmount = startHeal - (healStep*Age+healStep);
			} else {
				Skins[1]=Red[Age];
				HealingAmount = startHeal + (healStep*Age+healStep);
			}
			if (++Age == 4)
				SetTimer(0, false);
		}
	}

	function BeginState() {
		UntriggerEvent(Event, self, None);

		Skins[1] = default.Skins[1];
		HealingAmount = startHeal;

		if (bPoisonRules)
			bPoison = (FRand() < poisonChance);
		
		if ( bDropped )	{
			AddToNavigation();
			SetTimer(8, false);
		} else {
			Age = 0;
			SetTimer(ageFreq, true);
		}
	}

	function Touch( actor Other ) {
		local Pawn P;

		if (HealingAmount >= 0) {
			super.Touch(Other);
		} else {
			if ( ValidTouch(Other) ) {
				P = Pawn(Other);
				Other.TakeDamage(-HealingAmount, None, Location, vect(0,0,0), DamageType);
				SetRespawn();
			}
		}

	}

}

static function string GetLocalString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	return Default.PickupMessage;
}

defaultproperties
{
	Green(0)=Shader'AgedToPerfectionTextures.Green1Vial'
	Green(1)=Shader'AgedToPerfectionTextures.Green2Vial'
	Green(2)=Shader'AgedToPerfectionTextures.Green3Vial'
	Green(3)=Shader'AgedToPerfectionTextures.Green4Vial'
	Red(0)=Shader'AgedToPerfectionTextures.Red1Vial'
	Red(1)=Shader'AgedToPerfectionTextures.Red2Vial'
	Red(2)=Shader'AgedToPerfectionTextures.Red3Vial'
	Red(3)=Shader'AgedToPerfectionTextures.Red4Vial'
	PickupMessage="You picked up a Fermenting Health Vial"
	bPoison=false
	DamageType=AgedToPerfection.DamagePoisonVial

	bPoisonRules=false
	startHeal=5
	healStep=5
	ageFreq=30
	poisonChance=0.1
}